/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.core.Agent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;

public class Properties
extends Hashtable {
    private static final char SEPARATOR = '=';
    private static final String JAD = "jad";
    private static final String JAD_PREFIX = "LEAP-";
    private static final String JAD_PREFIX_old = "MIDlet-LEAP-";
    private boolean fromJad = false;

    public void load(String storage) throws IOException {
        this.clear();
        if (JAD.equals(storage)) {
            this.fromJad = true;
        } else {
            this.fromJad = false;
            this.recordstoreLoad(storage);
        }
    }

    public void store(String storage) throws IOException {
        this.recordstoreStore(storage);
    }

    public Object clone() {
        Properties p = new Properties();
        Enumeration enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.getProperty(key);
            if (value == null) continue;
            p.setProperty(key, value);
        }
        p.fromJad = this.fromJad;
        return p;
    }

    public synchronized Object setProperty(String key, String value) {
        return super.put(key, value);
    }

    public String getProperty(String key) {
        String prop = (String)super.get(key);
        if (prop == null && this.fromJad && Agent.midlet != null && (prop = Agent.midlet.getAppProperty(JAD_PREFIX + key)) == null) {
            prop = Agent.midlet.getAppProperty(JAD_PREFIX_old + key);
        }
        return prop;
    }

    public Enumeration propertyNames() {
        return this.keys();
    }

    private void recordstoreLoad(String name) throws IOException {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)name, (boolean)false);
        }
        catch (Exception e) {
            throw new IOException("Can't open recordstore " + name + ". " + e);
        }
        try {
            int size = rs.getNumRecords();
            int i = 0;
            while (i < size) {
                String line = new String(rs.getRecord(i + 1));
                int j = line.indexOf(61);
                if (j >= 0) {
                    String k = line.substring(0, j).trim();
                    if (j + 1 < line.length()) {
                        String v = line.substring(j + 1).trim();
                        if (!k.equals("") && !v.equals("")) {
                            this.put(k, v);
                        }
                    }
                }
                ++i;
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            throw new IOException("Error reading recordstore " + name + ". " + e);
        }
    }

    private void recordstoreStore(String name) throws IOException {
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            Enumeration keys = this.keys();
            while (keys.hasMoreElements()) {
                Object k = keys.nextElement();
                Object v = this.get(k);
                String line = k.toString() + '=' + v.toString();
                byte[] bb = line.getBytes();
                rs.addRecord(bb, 0, bb.length);
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            throw new IOException("Error writing recordstore " + name + ". " + e);
        }
    }
}

